<?php

	require_once("config.php");
	require_once("moz_api.php");

	$domain = $_POST['domain'];
	$regexes_together = $_POST['regexes'];
	$include_mode = (bool)($_POST['include']);
	$and_mode = (bool)($_POST['and']);

	$regexes = explode(PHP_EOL, trim($regexes_together));

	$selected_links = array();
	$all_links = fetch_all_backlinks($domain);
	
	foreach($all_links as $this_link)
	{
		$all_matched = true;
		$any_matched = false;

		foreach ($regexes as $regex)
		{
			$matching_url = preg_match(trim($regex), $this_link['luuu']);
			
			if ($matching_url)
			{
				$any_matched = true;
			}else{
				$all_matched = false;
			}
		}

		$add_this_url = ($and_mode ? $all_matched : $any_matched);

		if (!$include_mode)
			$add_this_url = !$add_this_url;

		if ($add_this_url)
			$selected_links[] = $this_link;

	}

?>

<!DOCTYPE html>
<html>
	<head>
		
		<title>Linkgex Results</title>
		<link href="//netdna.bootstrapcdn.com/twitter-bootstrap/2.3.1/css/bootstrap-combined.min.css" rel="stylesheet">	
		<link rel="stylesheet" href="styles.css" type="text/css">

	</head>
	<body>
    
	
	    <div class="container">
		    <section>
				<div class="row">
				    <div class="span16">
				    	<div class="page-header">
					        <h1>Linkgex</h1>
					    </div>
					       
				        <p>Results:</p>
				        
				        <table class="table table-striped table-bordered" id="resultsTable">
				        	<thead>
					          <tr class="blue">
					            <th>URL</th>
					            <th>PA</th>
					            <th>Linking&nbsp;URL</th>
					            <th>Link&nbsp;PA</th>
					            <th>Link&nbsp;DA</th>
					            <th>Anchor&nbsp;Text</th>
					          </tr>
					        </thead>
					        <tbody>
					        
					        	<?php
						        	
						        	$seperator = "****";
						        	$newline = "####";
						        	
						        	$download_string .= "URL" . $seperator;
						        	$download_string .= "PA" . $seperator;
						        	$download_string .= "Linking URL" . $seperator;
						        	$download_string .= "Link PA" . $seperator;
						        	$download_string .= "Link DA" . $seperator;
						        	$download_string .= "Anchor Text" . $seperator;
						        	
						        	$i = 0;
						        	
						        	
						        	


            
						        	foreach($selected_links as $this_link)
						        	{	
						            	echo '<tr><td>';
						          		echo trim($this_link['luuu']);
						          		echo '</td>';
						          		
						          		echo '<td>';
						          		echo round($this_link['luupa']);
						          		echo '</td>';
						          		
						          		echo '<td>';
						          		echo trim($this_link['uu']);
						          		echo '</td>';
						          		
						          		echo '<td>';
						          		echo round($this_link['upa']);
						          		echo '</td>';
						          		
						          		echo '<td>';
						          		echo round($this_link['pda']);
						          		echo '</td>';
						          		
						          		echo '<td>';
						          		echo trim(strip_tags($this_link['ut']));
						          		echo '</td>';
					          						            	
						          		echo '</tr>';
						          		
					        			$download_string .= $newline;
						        		$download_string .= trim($this_link['luuu']) . $seperator;
						          		$download_string .= round($this_link['luupa']) . $seperator;
						        		$download_string .= trim($this_link['uu']) . $seperator;
						          		$download_string .= round($this_link['upa']) . $seperator;
						          		$download_string .= round($this_link['pda']) . $seperator;
						        		$download_string .= trim($this_link['ut']);
						        	
							        	$i++;
							        	if ($i == 10)
							        		break;
						        	}
						        	
						        	//$download_string = substr($download_string, 0, -4);
						        	$download_string = str_ireplace($seperator,"\",\"", $download_string);
						        	$download_string = str_ireplace($newline,"\"\n\"", $download_string);
						        	$download_string = '"' . $download_string . '"';
						        	$download_string = rawurlencode($download_string);
						        	;
						        ?>
					        
					        
					        </tbody>
						</table>
						
						<a href="data:text/csv,<?=$download_string?>">Download CSV</a>
						
				    </div>
				</div>
			</section>
		</div>
		
	    <div class="container">
		    <footer>
				<div class="row">
				    <div class="span16">
						<p>This tool was built by <a href="http://twitter.com/TomAnthonySEO">@TomAnthonySEO</a>. Its free to use and comes with no guarantees.</p>
						<p>See my other <a href="http://www.tomanthony.co.uk/tools/">SEO tools</a>.</p>
					</div>
				</div>
			</footer>
		</div>
		
		<script src="//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js" type="text/javascript"></script>
		<script src="jquery.tablesorter.min.js"></script>

		<script >
		  $(function() {
		    $("table#resultsTable").tablesorter({ sortList: [[1,0]] });
		  });
		</script>
		
	</body>
</html>