<?php

	// Function to Generate Valid API Credentials from Your Access ID and Secret
	// Reference: http://apiwiki.seomoz.org/API-Credentials
	// This is thanks to Virante: http://www.thegooglecache.com/seomoz-linkscape-code.txt
	function generate_credentials() {
		global $moz_access_id,$moz_secret;
	
		date_default_timezone_set("America/Los_Angeles");
		
		$timestamp = mktime()+300;
		$hash = urlencode(base64_encode(custom_hmac('sha1',$moz_access_id."\n".$timestamp,$moz_secret,true)));
		$credentials  = "AccessID=$moz_access_id&Expires=$timestamp&Signature=$hash";
		return $credentials;
	}
	
	
	// Function to Create SHA1 Hash (from http://php.net/manual/en/function.hash-hmac.php)
	function custom_hmac($algo, $data, $key, $raw_output = false) {
	
		$algo = strtolower($algo);
		$pack = 'H'.strlen($algo('test'));
		$size = 64;
		$opad = str_repeat(chr(0x5C), $size);
		$ipad = str_repeat(chr(0x36), $size);
	
		if (strlen($key) > $size) {
			$key = str_pad(pack($pack, $algo($key)), $size, chr(0x00));
		} else {
			$key = str_pad($key, $size, chr(0x00));
		}
	
		for ($i = 0; $i < strlen($key) - 1; $i++) {
			$opad[$i] = $opad[$i] ^ $key[$i];
			$ipad[$i] = $ipad[$i] ^ $key[$i];
	    	}
	
		$output = $algo($opad.pack($pack, $algo($ipad.$data)));
		return ($raw_output) ? pack($pack, $output) : $output;
	}
	
	// Fetches the top links to the specified URL. Can take additional parameters
	// for nofollow settings, and settings for whether to get links to the entire domain.
	function fetch_backlinks($target_domain, $backlink_limit, $offset, $no_follow_included = false)
	{
		
		$credentials = generate_credentials();
		
		$scope = "page_to_domain";
		$sort = "page_authority";
		
		// NOTE: this will probably be 'equity' instead of 'follow' by the time you read this
		// http://apiwiki.seomoz.org/w/page/13991141/Links%20API
		// As of March 2013 it appears not to have been released yet.
		$filter = "+follow";
		
		if ($no_follow_included)
			$filter = "";
		
		$request = "http://lsapi.seomoz.com/linkscape/links/" . urlencode($target_domain) . "?" . generate_credentials() . "&SourceCols=103079215109&TargetCols=34359738372&Filter=external". $filter ."&Sort=" . $sort . "&Scope=" . $scope . "&Limit=" . intval($backlink_limit). "&Offset=" . intval($offset);
		//echo $request;

		// Increase the maximum execution time before we run CURL	
		set_time_limit(120);
	
		$ch = curl_init();
		
		curl_setopt($ch, CURLOPT_URL, $request); 
		curl_setopt($ch, CURLOPT_TIMEOUT, 180);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		
		$results = curl_exec($ch);
		$info = curl_getinfo($ch);
		curl_close($ch);
		
		if ($info['http_code'] != "200")
		{
			echo "Error occurred with SEOmoz API connection. Server returned a " . $info['http_code'] . " response.\n";
			exit(1);
		}
		
		// Decode the results from JSON into arrays
	    $links = json_decode($results,true);
	    
	    return $links;
	}

	function fetch_all_backlinks($domain, $output_progress = false)
	{
		global $api_pause;
		global $num_backlinks_to_inspect;
		
		$all_links = array();
		$offset = 0;
		$backlink_limit = 1000; // how many to get per API call

		$links = fetch_backlinks($domain,$backlink_limit,$offset);
		
		while ((count($links) > 5) && (($backlink_limit+$offset) <= $num_backlinks_to_inspect))
		{
			if ($output_progress)
				echo "fetched... " . ($backlink_limit+$offset) . " = " . count($links) . "\n";

			$all_links = array_merge($all_links, $links);
			
			sleep($api_pause);
			
			$links = fetch_backlinks($domain,$backlink_limit,$offset);
			$offset += $backlink_limit;
		}

		return $all_links;
	}

?>